<?php
/**
 * functions and definitions
 */

require_once( 'library/setup.php' );
require_once( 'library/widgets.php' ); 
require_once( 'library/neweb.php' );
require_once('library/wp-bootstrap-navwalker.php');
/* require_once('library/acf.php'); */


/* Implement the Custom Header feature. */
require get_template_directory() . '/library/underscores/custom-header.php';
/* Custom template tags for this theme. */ 
require get_template_directory() . '/library/underscores/template-tags.php';

/* Custom functions that act independently of the theme templates. */
require get_template_directory() . '/library/underscores/extras.php';

/* Customizer additions. */
require get_template_directory() . '/library/underscores/customizer.php';

/* Load Jetpack compatibility file. */
require get_template_directory() . '/library/underscores/jetpack.php';


/* Enqueue scripts and styles */
function tpbc_scripts() {
    /* load tpbc styles */
    wp_enqueue_style( 'tpbc-style', get_stylesheet_uri() ); 
    /* load bootstrap for WordPress css */
	wp_enqueue_style( 'css_main', get_template_directory_uri() . '/css_main.css' );	
	wp_enqueue_style( 'tpbc-bootstrap', get_template_directory_uri() . '/assets/css/bootstrap/bootstrap.min.css' ); 
	wp_enqueue_style( 'tpbc-bootstrap-reboot', get_template_directory_uri() . '/assets/css/bootstrap/bootstrap-reboot.min.css' );
  
 
    /* load bootstrap for WordPress css */
    wp_enqueue_style( 'tpbc-bootstrapwp', get_template_directory_uri() . '/assets/css/bootstrap-wp.css' );
	/* load bootstrap.js */
	wp_enqueue_script('tpbc-bootstrapjs', get_template_directory_uri().'/assets/js/bootstrap/bootstrap.bundle.min.js#asyncload', array('jquery') );
	wp_enqueue_script('tpbc-popperjs', get_template_directory_uri().'/assets/js/bootstrap/popper.min.js#asyncload', array('jquery') );
  
   
	/*******************************************/
	/*Slick Slider*/
	
	wp_enqueue_style( 'slick-css', get_template_directory_uri() .'/slick/slick.css' ); 
	wp_enqueue_style( 'slick-theme-css', get_template_directory_uri() .'/slick/slick-theme.css' ); 
	/* wp_enqueue_script( 'slick-js', get_template_directory_uri() .'/slick/slick.js#asyncload', array(), '112222', true ); */
	/*******************************************/
	wp_enqueue_script( 'dental-js', get_template_directory_uri() .'/assets/js/js_dental.js#asyncload', array(), '1.5.7', false );
	/*******************************************/
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) { 	wp_enqueue_script( 'comment-reply' );    }

    /*load keyboard-image-navigation.js */
    if ( is_singular() && wp_attachment_is_image() ) {
        wp_enqueue_script( 'tpbc-keyboard-image-navigation', get_template_directory_uri() . '/assets/js/keyboard-image-navigation.js#asyncload', array( 'jquery' ), '20120202' ); 
    } 
}
add_action( 'wp_enqueue_scripts', 'tpbc_scripts', 100);

/**************************************************************************************************/
function dental_async_scripts($url)
{
    if ( strpos( $url, '#asyncload') === false )
        return $url;
    else if ( is_admin() )
        return str_replace( '#asyncload', '', $url );
    else
	return str_replace( '#asyncload', '', $url )."' async='async";
    }
add_filter( 'clean_url', 'dental_async_scripts', 11, 1 );

/***********************************************************************************/
add_theme_support( 'post-thumbnails' );
/***********************************************************************************/


function fn_goggle_scripts_customizer( $wp_customize ) {           
  
    /* your section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section0', 
            array(
                'title' => esc_html__( 'Google GA, GTM and Meta codes', 'dental' ),
                'priority' => 150
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code0($input){
            return base64_encode($input);
        }
         
         
    /* output escape function     */
        function theme_slug_escape_js_output0($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
             'google_js_code',  
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code0', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output0' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
             'google_js_code', 
            array(
                'label' => esc_html__( 'SEO Codes and Google Scripts', 'dental' ),
                'section' => 'theme_slug_customizer_your_section0',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_goggle_scripts_customizer' );

/****************************************************************/

function fn_header_scripts_customizer( $wp_customize ) {           
  
    /* your section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section1', 
            array(
                'title' => esc_html__( 'Additional Header Scripts', 'dental' ),
                'priority' => 150
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code1($input){
            return base64_encode($input);
        }
         
         
    /* output escape function     */
        function theme_slug_escape_js_output1($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
             'header_js_code',  
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code1', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output1' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
             'header_js_code', 
            array(
                'label' => esc_html__( 'JavaScript code', 'dental' ),
                'section' => 'theme_slug_customizer_your_section1',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_header_scripts_customizer' );

/****************************************************************/


function fn_body_scripts_customizer( $wp_customize ) {           
  
    /* your section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section2', 
            array(
                'title' => esc_html__( 'Additional Body Scripts', 'dental' ),
                'priority' => 151
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code2($input){
            return base64_encode($input);
        }
         
         
    /* output escape function     */
        function theme_slug_escape_js_output2($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
            'body_js_code', 
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code2', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output2' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
            'body_js_code', 
            array(
                'label' => esc_html__( 'JavaScript code', 'dental' ),
                'section' => 'theme_slug_customizer_your_section2',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_body_scripts_customizer' );

/****************************************************************/

function fn_footer_scripts_customizer( $wp_customize ) {           
  
    /* your section */
        $wp_customize->add_section( 
            'theme_slug_customizer_your_section3', 
            array(
                'title' => esc_html__( 'Additional Footer Scripts', 'dental' ),
                'priority' => 151
            )
        );      
          
             
    /* script input sanitization function */
        function theme_slug_sanitize_js_code3($input){
            return base64_encode($input);
        }
         
         
    /* output escape function     */
        function theme_slug_escape_js_output3($input){
            return esc_textarea( base64_decode($input) );
        }
         
                  
    /* add setting to your section */
        $wp_customize->add_setting( 
            'footer_js_code', 
            array(          
                'sanitize_callback' => 'theme_slug_sanitize_js_code3', /* encode for DB insert */
                'sanitize_js_callback' => 'theme_slug_escape_js_output3' /*  script for the textarea */
            )
        );
         
        $wp_customize->add_control( 
            'footer_js_code', 
            array(
                'label' => esc_html__( 'JavaScript code', 'dental' ),
                'section' => 'theme_slug_customizer_your_section3',
                'type' => 'textarea'
            )
        );         
      
}
add_action( 'customize_register', 'fn_footer_scripts_customizer' );

/****************************************************************/


/*Recent Blog Section*/
function fn_recent_blogs(){
$args = array( 
				'posts_per_page' => 5,
				'post_type' =>'post',
				'post_status' =>'publish',
				'orderby' => 'date', 
				'order' => 'DESC',
				
			);
		$the_query = new WP_Query( $args );
		ob_start();
		?>
		<div class="recent-post-section">
		<h2 class="widget-title">Recent Blogs</h2>
			<ul>
				<?php
				while ( $the_query->have_posts() ) : $the_query->the_post();
				 ?>
					<li class="list">
						<div class="postcontent">
						
						<a href="<?php the_permalink(); ?>" class="recent-post-image">
							<div style="background-image: url(<?php echo get_the_post_thumbnail_url(); ?>);"></div>
						</a>
						<div class="post_info"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
						</div>
					</li>
				 <?php
				endwhile;
				?>
			</ul>			
		</div>
		

<?php
return ob_get_clean();
wp_reset_postdata();
}
add_shortcode("recent_blogs","fn_recent_blogs"); 

/*  Recent Blog Shortcode : [recent_blogs] */
/***************************************************************************************************/

function fn_homepage_slider(){
	ob_start();
?>
<section class="homepage-slider-main">
	
	<div class="homepage-slider">
		<?php 
		if( have_rows('slide') ):
		$counter=1;
			while ( have_rows('slide') ) : the_row();  
			
			$content_position=get_sub_field("content_position");
			$background_position=get_sub_field("background_position");
			$background_size=get_sub_field("background_size");
			$overlay_option=get_sub_field("overlay_option");
			if(get_sub_field("overlay_color")){
				$overlay_color=get_sub_field("overlay_color");
			}else{
				$overlay_color='transparent';
			}
		?>
		<div class="slide-main slide<?php echo $counter; ?>" style="background:url(<?php the_sub_field("slide_image"); ?>) no-repeat <?php echo $background_position; ?>; background-size: <?php echo $background_size; ?>">
			<img src="<?php echo get_sub_field("slide_mobile_image"); ?>" class="mobile-slide d-block d-md-none" alt="mobile slide" >
			<div class="slide-inner content-on-<?php echo $content_position; ?>  <?php echo $overlay_option; ?> " style="background-color: <?php echo $overlay_color; ?>">
            	<div class="slide-inner-text">
					<span class="bdr-top-left"></span>
					<span class="bdr-top-bottom"></span>
					<span class="bdr-left-bottom"></span>
					<span class="bdr-bottom"></span>
				<?php if(get_sub_field('slide_heading')){ ?>
				<h2><?php the_sub_field("slide_heading"); ?></h2>
				<?php } ?>
				
				<?php if(get_sub_field('slide_sub_heading')){ ?>
				<div class="sub-heading-text"><?php the_sub_field("slide_sub_heading"); ?></div>
				<?php } ?>
				
				<?php if( get_sub_field('button_1_text') && get_sub_field('button_2_text')){ ?>
				<div class="slide-both-btns slider-btns">
					<a href="<?php echo get_sub_field('button_1_url'); ?>" class="slide-btn-1"><?php echo get_sub_field('button_1_text'); ?></a>
					<a href="<?php echo get_sub_field('button_2_url'); ?>" class="slide-btn-2"><?php echo get_sub_field('button_2_text'); ?></a>
				</div>
				
				<?php }elseif( get_sub_field('button_1_text') && !get_sub_field('button_2_text')){ ?>
				<div class="slide-only-btn1 slider-btns">
					<a href="<?php echo get_sub_field('button_1_url'); ?>" class="slide-btn-1"><?php echo get_sub_field('button_1_text'); ?></a>
				</div>
				
				<?php }elseif( !get_sub_field('button_1_text') && get_sub_field('button_2_text')){ ?>
				<div class="slide-only-btn2 slider-btns">
					<a href="<?php echo get_sub_field('button_2_url'); ?>" class="slide-btn-2"><?php echo get_sub_field('button_2_text'); ?></a>
				</div>
				
				<?php }else{ 
					/*No Buttons*/
				 } ?>
				</div>
			</div>
		</div>
		<?php 	
		$counter++;
		endwhile;

		else :

			// no rows found

		endif;
		?>	
				
	</div>
</section>

<?php
return ob_get_clean();
}
add_shortcode("homepage_slider","fn_homepage_slider"); 
/*****************************************************************/

function fn_service_posttype() { 
	register_post_type( 'services',

		array(
			'labels' => array(
				'name' => __( 'Services' ),
				'singular_name' => __( 'Service')
			),
			'public' => true,
			'has_archive' => false,
			'rewrite' => array('slug' => 'services','with_front' => false), 
			'supports' => array( 'title', 'revisions','editor','excerpt','thumbnail' ),
			
		)
	);
}
add_action( 'init', 'fn_service_posttype' );


function fn_services_listing(){
$exclude=get_the_ID();
$args = array( 
				'posts_per_page' => 12,
				'post_type' =>'services',
				'post_status' =>'publish',
				'orderby' => 'date', 
				'order' => 'ASC',
				'post__not_in' => array($exclude),
				
			);
	$the_query = new WP_Query( $args );
	ob_start();
	if ( $the_query->have_posts() ) {
	?>	<h2 class="section-title">Our Services</h2>
		<ul class="custom-sv-list">
		<?php	while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
			<li><h3><a href="<?php the_permalink(); ?>"><span><?php the_title(); ?></span></a></h3></li>
		<?php	endwhile;	?>
		</ul>
	<?php
	}
	return ob_get_clean();
	wp_reset_postdata();
}
add_shortcode("services_listing","fn_services_listing"); 
/**************************************************************/

if(class_exists('WPBakeryShortCode')) {
class vsThumbGallerySlider extends WPBakeryShortCode {
     
    function __construct() {
        add_action( 'init', array( $this, 'vsThumbGallerySlider_mapping' ) );
        add_shortcode( 'vsThumbGallery', array( $this, 'vsThumbGallery_html' ) );
    }
     
    
    public function vsThumbGallerySlider_mapping() {
         
    
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
    
        vc_map( 
            array(
                'name' => __('Thumbnail Gallery', 'text-domain'),
                'base' => 'vsThumbGallery',
                'description' => __('Thumbnail Gallery', 'text-domain'),  
                'category' => __('Advanced Dental Modules', 'text-domain'),   
                'icon' => get_template_directory_uri().'/images/visual_composer_32.png',            
                'params' => array(   
                         
                    array(
                        'type' => 'textfield',
                        'holder' => 'h3',
                        'class' => 'title-class',
                        'heading' => __( 'Slider Title', 'text-domain' ),
                        'param_name' => 'title',
                        'value' => __( '', 'text-domain' ),
                        'description' => __( '', 'text-domain' ),
                        'admin_label' => false,
                        'weight' => 0,
                        'group' => 'Custom Group',
                    ),  
					
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 1 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_1_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 1 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_1_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 2 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_2_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 2 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_2_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 3 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_3_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 3 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_3_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 4 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_4_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 4 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_4_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 5 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_5_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 5 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_5_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 6 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_6_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 6 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_6_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 7 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_7_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 7 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_7_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 8 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_8_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 8 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_8_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					
					array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 9 Small Image', 'my-text-domain' ),
					  'param_name' => 'slider_9_small_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
					
                   array(
					  'type' => 'attach_image',
					   'holder' => 'div',
                        'class' => 'image-class',
					  'class' => '',
					  'heading'=> __( 'Slider 9 Big Image', 'my-text-domain' ),
					  'param_name' => 'slider_9_big_image',
					  'value' => '',
					  'description' => __( '', 'text-domain' ),
					  'admin_label' => false,
                      'weight' => 0,
                      'group' => 'Custom Group',
					),
                   
					
					
                        
                ),
            )
        );                                
        
    }
     
     
   
public function vsThumbGallery_html( $atts ) {
	
	$gallery = shortcode_atts(
				array(
					'slider_1_small_image'    =>  'slider_1_small_image',
					'slider_2_small_image'    =>  'slider_2_small_image',
					'slider_3_small_image'    =>  'slider_3_small_image',
					'slider_4_small_image'    =>  'slider_4_small_image',
					'slider_5_small_image'    =>  'slider_5_small_image',
					'slider_6_small_image'    =>  'slider_6_small_image',
					'slider_7_small_image'    =>  'slider_7_small_image',
					'slider_8_small_image'    =>  'slider_8_small_image',
					'slider_9_small_image'    =>  'slider_9_small_image',
					
					'slider_1_big_image'      =>  'slider_1_big_image',
					'slider_2_big_image'      =>  'slider_2_big_image',
					'slider_3_big_image'      =>  'slider_3_big_image',
					'slider_4_big_image'      =>  'slider_4_big_image',
					'slider_5_big_image'      =>  'slider_5_big_image',
					'slider_6_big_image'      =>  'slider_6_big_image',
					'slider_7_big_image'      =>  'slider_7_big_image',
					'slider_8_big_image'      =>  'slider_8_big_image',
					'slider_9_big_image'      =>  'slider_9_big_image',
				), $atts );
				
				
				
				
			$small_slide1 =	wp_get_attachment_image_src( $gallery['slider_1_small_image'], 'full' );
			$small_slide2 =	wp_get_attachment_image_src( $gallery['slider_2_small_image'], 'full' );
			$small_slide3 =	wp_get_attachment_image_src( $gallery['slider_3_small_image'], 'full' );
			$small_slide4 =	wp_get_attachment_image_src( $gallery['slider_4_small_image'], 'full' );
			$small_slide5 =	wp_get_attachment_image_src( $gallery['slider_5_small_image'], 'full' );
			$small_slide6 =	wp_get_attachment_image_src( $gallery['slider_6_small_image'], 'full' );
			$small_slide7 =	wp_get_attachment_image_src( $gallery['slider_7_small_image'], 'full' );
			$small_slide8 =	wp_get_attachment_image_src( $gallery['slider_8_small_image'], 'full' );
			$small_slide9 =	wp_get_attachment_image_src( $gallery['slider_9_small_image'], 'full' );
			
			$big_slide1 =	wp_get_attachment_image_src( $gallery['slider_1_big_image'], 'full' );
			$big_slide2 =	wp_get_attachment_image_src( $gallery['slider_2_big_image'], 'full' );
			$big_slide3 =	wp_get_attachment_image_src( $gallery['slider_3_big_image'], 'full' );
			$big_slide4 =	wp_get_attachment_image_src( $gallery['slider_4_big_image'], 'full' );
			$big_slide5 =	wp_get_attachment_image_src( $gallery['slider_5_big_image'], 'full' );
			$big_slide6 =	wp_get_attachment_image_src( $gallery['slider_6_big_image'], 'full' );
			$big_slide7 =	wp_get_attachment_image_src( $gallery['slider_7_big_image'], 'full' );
			$big_slide8 =	wp_get_attachment_image_src( $gallery['slider_8_big_image'], 'full' );
			$big_slide9 =	wp_get_attachment_image_src( $gallery['slider_9_big_image'], 'full' );
			
			
				
	ob_start();
	?>
	<div class="thumb-gallery-main">
		<div class="view-main">
		
		<figure class="main-slide" style="width:100%; background-image:url(<?php echo $big_slide1[0]; ?>)"><img src="<?php echo get_template_directory_uri(); ?>/images/blank.png" alt="slide"></figure> 
		<div class="navigation">
			<a href="#" class="previous-slide"> <img src="<?php echo get_template_directory_uri(); ?>/images/left-icon.png" alt="Left Icon"> </a> <a href="#" class="next-slide"><img src="<?php echo get_template_directory_uri(); ?>/images/rt-icon.png" alt="Right Icon"> </a>
		</div> 
	</div>
	<div class="thumb-section">
	<ul class="thumb-slides">
		<li class="slide-1 active" style="background:url(<?php echo $small_slide1[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide1[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-2" style="background:url(<?php echo $small_slide2[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide2[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-3" style="background:url(<?php  echo $small_slide3[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide3[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-4" style="background:url(<?php  echo $small_slide4[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide4[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-5" style="background:url(<?php  echo $small_slide5[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide5[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-6" style="background:url(<?php  echo $small_slide6[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide6[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-7" style="background:url(<?php  echo $small_slide7[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide7[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-8" style="background:url(<?php  echo $small_slide8[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide8[0]; ?>" style="opacity:0;" alt="slide-image"></li>
		<li class="slide-9" style="background:url(<?php  echo $small_slide9[0]; ?>) no-repeat center center; "><img src="<?php echo $big_slide9[0]; ?>" style="opacity:0;" alt="slide-image"></li>
	</ul>
	</div>
		

	</div>
	
	
<script>
jQuery(document).ready(function(){
	
	jQuery(".thumb-slides li").on("click", function(){
		jQuery(".thumb-slides").find(".active").removeClass("active");
		jQuery(this).addClass("active");
		var nextImage= jQuery(this).find('img').attr('src');
		jQuery(this).find('img').closest("li").addClass('active');
	
		jQuery("figure.main-slide").css({"background": "url("+nextImage+")"});
	});
	
	jQuery("a.next-slide").on("click",function(e){
		e.preventDefault();
		if(jQuery( ".slide-9" ).hasClass( "active" )){
			/*nothing to do */
		
		}else{
					
			var activeLi= jQuery(".thumb-slides").find(".active");
			var nextLi= jQuery(activeLi).next();
			jQuery(activeLi).removeClass("active");
			jQuery( nextLi ).addClass("active");
			var nextBtnImage= jQuery(nextLi).find("img").attr("src");
			jQuery("figure.main-slide").css({"background": "url("+nextBtnImage+")"});
		}
					
	});			
	jQuery("a.previous-slide").on("click",function(e){
		e.preventDefault();
		if(jQuery( ".slide-1" ).hasClass( "active" )){
			/*nothing to do */
					
		}else{
			var activeLi= jQuery(".thumb-slides").find(".active");
			var prevLi= jQuery(activeLi).prev();
			jQuery(activeLi).removeClass("active");
			jQuery( prevLi ).addClass("active");
			var prevBtnImage= jQuery(prevLi).find("img").attr("src");
			jQuery("figure.main-slide").css({"background": "url("+prevBtnImage+")"});	
		
		}
		
	});				
	

});
</script>
	<?php
	return ob_get_clean();
}
} 
new vsThumbGallerySlider();
}

/************************************************************************/
function fn_content_slide_posttype() { 
	register_post_type( 'content-slide',

		array(
			'labels' => array(
				'name' => __( 'Content Slides' ),
				'singular_name' => __( 'Content Slide')
			),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => 'content-slide'),
			'supports' => array( 'title', 'revisions','editor','excerpt','thumbnail' ),
		)
	);
}
add_action( 'init', 'fn_content_slide_posttype' );

function fn_content_slider(){

		$args = array( 
			'posts_per_page' => -1,
			'post_type' =>'content-slide',
			'post_status' =>'publish',
			'orderby' => 'date', 
			'order' => 'ASC'
		);
		
		$the_query = new WP_Query( $args );
		ob_start();
		?>
		<section class="doctor">
         <div class="container">
             <div class="row">
                <div class="col-md-12">
                    <div class="doctor__slider">
					 <?php 	while ( $the_query->have_posts() ) : $the_query->the_post();	?>
                       <div class="doctor__slider_inner">
							<div class="row">
								<div class="col-md-6">
									<div class="doctor__slider__thumbnail  text-md-right">
										<img src="<?php echo get_field("slide_image"); ?>" alt="<?php the_title(); ?>" />
									</div>
								</div>   
								<div class="col-md-6 d-flex align-items-center">
									<div class="doctor__slider__content">
										 <h2><?php the_title(); ?></h2>
										 <div class="slide_content"><?php the_content	(); ?></div>
										 <a href="<?php echo get_field("slide_url",get_the_ID()); ?>" class="team-btn">LEARN MORE</a>
									</div>
								</div>
							</div>
						</div>
						<?php	
							endwhile;	
							wp_reset_postdata();
						?>
                    </div>
                </div>
             </div>
         </div>
     </section> 
	<?php
	return ob_get_clean();
}
add_shortcode("content_slider","fn_content_slider"); 


function custom_excerpt_length( $length ) { return 50; }  

function excerpt_readmore($more) { return ' ...'; }
add_filter('excerpt_more', 'excerpt_readmore');